<?php

namespace Albedo\Duel;

use Albedo\Duel\Contracts\DuelUserDataProvider;
use Albedo\Gamification\Contracts\HasAvatar;

class DefaultDuelUserDataProvider implements DuelUserDataProvider
{
    public function getData($user): array
    {
        $data = [
            'first_name' => $user->first_name ?? 'N\A',
            'last_name' => $user->short_last_name ?? 'N\A',
            'name' => $user->shortName ?? 'N\A',
        ];

        if ($user instanceof HasAvatar) {
            $data = array_merge(
                ['avatar' => [
                    'id' => $user->getAvatarId(),
                    'name' => $user->getAvatarUrl(),
                ]],
                $data
            );
        }

        return $data;
    }
}
