<?php

use Albedo\Duel\Models\DuelQuestionCategory;
use Albedo\Duel\Models\DuelRound;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('duel_questions', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(DuelRound::class);
            $table->foreignIdFor(DuelQuestionCategory::class);
            $table->text('question');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('duel_questions');
    }
};
