<?php

namespace Albedo\Duel\Services;

use Albedo\Duel\Http\Resources\DuelResource;
use Albedo\Duel\Models\Duel;

class DuelDetailsService
{
    public function handle(Duel $duel, int $userId): DuelResource
    {
        $duel->load([
            'duelUsers.duelUserAnswers.duelAnswer',
            'duelUsers.duelUserAnswers.duelQuestion.duelQuestionCategory',
            'duelUsers.duelUserAnswers.duelQuestion.duelAnswers',
            'duelRound',
        ]);
        $me = $duel->duelUsers->where('user_id', $userId)->first();
        $opponent = $duel->duelUsers->where('user_id', '!=', $userId)->first();
        return DuelResource::make($duel)
            ->additional(['me' => $me, 'opponent' => $opponent, 'total_questions']);
    }
}
