<?php

namespace Albedo\Duel\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class DuelQuestionCategory extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'name',
        'quantity_in_duel',
    ];

    public function duelQuestions(): HasMany
    {
        return $this->hasMany(DuelQuestion::class);
    }

    protected static function newFactory()
    {
        return \Albedo\Duel\Database\Factories\DuelQuestionCategoryFactory::new();
    }
}
