<?php

namespace Albedo\Duel\Filament\Resources\Duels\Schemas;

use Filament\Infolists\Components\IconEntry;
use Filament\Infolists\Components\RepeatableEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class DuelInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('duelRound.name')
                    ->label('Runda'),
                TextEntry::make('duelRound.begin_date')
                    ->label('Data startu'),
                TextEntry::make('duelRound.end_date')
                    ->label('Data zakończenia'),
                TextEntry::make('progress_status')
                    ->label('Status pojedynku'),

                RepeatableEntry::make('duelUsers')
                    ->label('Uczestnicy')
                    ->schema([
                        TextEntry::make('user.full_name')
                            ->label('Imię i nazwisko'),
                        TextEntry::make('progress_status')
                            ->label('Status progresu'),
                        TextEntry::make('result_status')
                            ->label('Status pojedynku'),
                        TextEntry::make('points')
                            ->label('Punkty'),
                        TextEntry::make('time')
                            ->label('Czas'),

                        RepeatableEntry::make('duelUserAnswers')
                            ->label('Odpowiedzi')
                            ->schema([
                                TextEntry::make('number')
                                    ->label('Lp.'),
                                TextEntry::make('duelQuestion.question')
                                    ->label('Pytanie'),
                                IconEntry::make('is_correct')
                                    ->boolean()
                                    ->label('Czy twoja odpowiedź jest poprawna'),
                                TextEntry::make('duelAnswer.answer')
                                    ->label('Twoja odpowiedź'),
                            ]),
                    ])->columnSpanFull()
                    ->grid(2),
            ]);
    }
}
