<?php

namespace Albedo\Duel\Filament\Resources\Duels;

use Albedo\Duel\Models\Duel;
use Albedo\Duel\Filament\Resources\Duels\Pages\CreateDuel;
use Albedo\Duel\Filament\Resources\Duels\Pages\EditDuel;
use Albedo\Duel\Filament\Resources\Duels\Pages\ListDuels;
use Albedo\Duel\Filament\Resources\Duels\Pages\ViewDuel;
use Albedo\Duel\Filament\Resources\Duels\Schemas\DuelForm;
use Albedo\Duel\Filament\Resources\Duels\Schemas\DuelInfolist;
use Albedo\Duel\Filament\Resources\Duels\Tables\DuelsTable;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use UnitEnum;

class DuelResource extends Resource
{
    protected static ?string $model = Duel::class;

    protected static string|UnitEnum|null $navigationGroup = "Duels";
    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedFire;
    protected static ?string $label = 'Duel';
    protected static ?string $pluralLabel = 'Duels';

    protected static ?int $navigationSort = 60;

    public static function form(Schema $schema): Schema
    {
        return DuelForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return DuelInfolist::configure($schema);
    }
    public static function table(Table $table): Table
    {
        return DuelsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListDuels::route('/'),
            //'create' => CreateDuel::route('/create'),
            //'edit' => EditDuel::route('/{record}/edit'),
            'view' => ViewDuel::route('/{record}'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
