<?php

namespace Albedo\Duel\Filament\Resources\DuelRounds\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Group;
use Filament\Schemas\Schema;

class DuelRoundForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->required(),
                Group::make([
                    DateTimePicker::make('begin_date')
                        ->beforeOrEqual('end_date')
                        ->nullable(),
                    DateTimePicker::make('end_date')
                        ->afterOrEqual('begin_date')
                        ->nullable(),
                ])
                    ->columns(2),
            ])
            ->columns(1);
    }
}
