<?php

namespace Albedo\Duel\Filament\Resources\DuelRounds;

use Albedo\Duel\Models\DuelRound;
use Albedo\Duel\Filament\Resources\DuelRounds\Pages\CreateDuelRound;
use Albedo\Duel\Filament\Resources\DuelRounds\Pages\EditDuelRound;
use Albedo\Duel\Filament\Resources\DuelRounds\Pages\ListDuelRounds;
use Albedo\Duel\Filament\Resources\DuelRounds\Schemas\DuelRoundForm;
use Albedo\Duel\Filament\Resources\DuelRounds\Tables\DuelRoundsTable;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use UnitEnum;

class DuelRoundResource extends Resource
{
    protected static ?string $model = DuelRound::class;

    protected static string|UnitEnum|null $navigationGroup = "Duels";
    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedCalendarDateRange;
    protected static ?string $label = 'Duel Round';
    protected static ?string $pluralLabel = 'Duel Rounds';

    protected static ?int $navigationSort = 50;

    public static function form(Schema $schema): Schema
    {
        return DuelRoundForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return DuelRoundsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListDuelRounds::route('/'),
            'create' => CreateDuelRound::route('/create'),
            'edit' => EditDuelRound::route('/{record}/edit'),
        ];
    }
}
