<?php

namespace Albedo\Duel\Filament\Resources\DuelQuestions\Schemas;

use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Notifications\Notification;
use Filament\Schemas\Schema;

class DuelQuestionForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('duel_question_category_id')
                    ->relationship('duelQuestionCategory', 'name')
                    ->required()
                    ->label('Category'),
                TextInput::make('question')
                    ->required(),
                Toggle::make('is_active')
                    ->required(),

                Repeater::make('answers')
                    ->relationship('duelAnswers')
                    ->maxItems(4)
                    ->schema([
                        TextInput::make('answer')
                            ->required(),
                        Toggle::make('is_valid')
                    ])
                    ->columnSpanFull()
                    ->deletable(false)
            ]);
    }
}
