<?php

namespace Albedo\Duel\Filament\Resources\DuelQuestions;

use Albedo\Duel\Models\DuelQuestion;
use Albedo\Duel\Filament\Resources\DuelQuestions\Pages\CreateDuelQuestion;
use Albedo\Duel\Filament\Resources\DuelQuestions\Pages\EditDuelQuestion;
use Albedo\Duel\Filament\Resources\DuelQuestions\Pages\ListDuelQuestions;
use Albedo\Duel\Filament\Resources\DuelQuestions\Schemas\DuelQuestionForm;
use Albedo\Duel\Filament\Resources\DuelQuestions\Tables\DuelQuestionsTable;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use UnitEnum;

class DuelQuestionResource extends Resource
{
    protected static ?string $model = DuelQuestion::class;
    protected static string|UnitEnum|null $navigationGroup = "Duels";
    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedChatBubbleLeftRight;
    protected static ?string $label = 'Question';
    protected static ?string $pluralLabel = 'Questions';

    protected static ?int $navigationSort = 30;

    public static function form(Schema $schema): Schema
    {
        return DuelQuestionForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return DuelQuestionsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListDuelQuestions::route('/'),
            'create' => CreateDuelQuestion::route('/create'),
            'edit' => EditDuelQuestion::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
