<?php

namespace Albedo\Duel\Filament\Resources\DuelQuestionCategories;

use Albedo\Duel\Models\DuelQuestionCategory;
use Albedo\Duel\Filament\Resources\DuelQuestionCategories\Pages\CreateDuelQuestionCategory;
use Albedo\Duel\Filament\Resources\DuelQuestionCategories\Pages\EditDuelQuestionCategory;
use Albedo\Duel\Filament\Resources\DuelQuestionCategories\Pages\ListDuelQuestionCategories;
use Albedo\Duel\Filament\Resources\DuelQuestionCategories\Schemas\DuelQuestionCategoryForm;
use Albedo\Duel\Filament\Resources\DuelQuestionCategories\Tables\DuelQuestionCategoriesTable;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use UnitEnum;

class DuelQuestionCategoryResource extends Resource
{
    protected static ?string $model = DuelQuestionCategory::class;

    protected static string|UnitEnum|null $navigationGroup = "Duels";
    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedTag;
    protected static ?string $label = 'Category';
    protected static ?string $pluralLabel = 'Categories';

    protected static ?int $navigationSort = 10;

    public static function form(Schema $schema): Schema
    {
        return DuelQuestionCategoryForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return DuelQuestionCategoriesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListDuelQuestionCategories::route('/'),
            'create' => CreateDuelQuestionCategory::route('/create'),
            'edit' => EditDuelQuestionCategory::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
            ]);
    }
}
