<?php

namespace Albedo\Duel\Filament\Resources\DuelAnswers\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ForceDeleteBulkAction;
use Filament\Actions\RestoreBulkAction;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Filters\TrashedFilter;
use Filament\Tables\Table;

class DuelAnswersTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('id')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('duelQuestion.duelQuestionCategory.name')
                    ->searchable()
                    ->label('Category'),
                TextColumn::make('duelQuestion.question')
                    ->limit(255)
                    ->wrap()
                    ->label('Question'),
                IconColumn::make('duelQuestion.is_active')
                    ->boolean()
                    ->label('Is active question'),
                TextColumn::make('answer')
                    ->limit(255)
                    ->wrap()
                    ->label('Answer'),
                IconColumn::make('is_valid')
                    ->boolean()
                    ->label('Is correct'),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('deleted_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                TrashedFilter::make(),
                SelectFilter::make('duel_question_id')
                    ->relationship('duelQuestion', 'question')
                    ->preload()
                    ->searchable()
                    ->label('Pytanie'),
                SelectFilter::make('is_valid')
                    ->options([
                        0 => 'Niepoprawna odpowiedź',
                        1 => 'Poprawna odpowiedź'
                    ])->label('Status odpowiedzi')

            ])
            ->recordActions([
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                    ForceDeleteBulkAction::make(),
                    RestoreBulkAction::make(),
                ]),
            ]);
    }
}
