<?php

namespace Albedo\Duel\Filament\Resources\DuelAnswers\Schemas;

use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Schema;

class DuelAnswerForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('duel_question_id')
                    ->relationship('duelQuestion', 'question')
                    ->disabled()
                    ->label('Question'),
                TextInput::make('answer')
                    ->required()
                    ->label('Answer'),
                Toggle::make('is_valid')
                    ->label('Is correct')
                    ->disabled()
            ]);
    }
}
