<?php

namespace Albedo\Duel\Filament\Resources\DuelAnswers;

use Albedo\Duel\Models\DuelAnswer;
use Albedo\Duel\Filament\Resources\DuelAnswers\Pages\CreateDuelAnswer;
use Albedo\Duel\Filament\Resources\DuelAnswers\Pages\EditDuelAnswer;
use Albedo\Duel\Filament\Resources\DuelAnswers\Pages\ListDuelAnswers;
use Albedo\Duel\Filament\Resources\DuelAnswers\Schemas\DuelAnswerForm;
use Albedo\Duel\Filament\Resources\DuelAnswers\Tables\DuelAnswersTable;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use UnitEnum;

class DuelAnswerResource extends Resource
{
    protected static ?string $model = DuelAnswer::class;
    protected static string|UnitEnum|null $navigationGroup = "Duels";
    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedChatBubbleLeft;
    protected static ?string $label = 'Answer';
    protected static ?string $pluralLabel = 'Answers';

    protected static ?int $navigationSort = 40;

    public static function form(Schema $schema): Schema
    {
        return DuelAnswerForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return DuelAnswersTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListDuelAnswers::route('/'),
            'create' => CreateDuelAnswer::route('/create'),
            'edit' => EditDuelAnswer::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
