<?php

namespace Albedo\Duel\Filament;

use Albedo\Duel\Filament\Resources\DuelAnswers\DuelAnswerResource;
use Albedo\Duel\Filament\Resources\DuelQuestionCategories\DuelQuestionCategoryResource;
use Albedo\Duel\Filament\Resources\DuelQuestions\DuelQuestionResource;
use Albedo\Duel\Filament\Resources\DuelRounds\DuelRoundResource;
use Albedo\Duel\Filament\Resources\Duels\DuelResource;
use Albedo\Questionnaire\Filament\Resources\Questionnaires\QuestionnaireResource;
use Filament\Contracts\Plugin;
use Filament\Panel;

class DuelPlugin implements Plugin
{
    public function getId(): string
    {
        return 'duel';
    }

    public function register(Panel $panel): void
    {
        $panel
            ->resources([
                DuelResource::class,
                DuelRoundResource::class,
                DuelQuestionResource::class,
                DuelQuestionCategoryResource::class,
                DuelAnswerResource::class,
            ]);
    }

    public function boot(Panel $panel): void
    {
        //
    }

    public static function make(): static
    {
        return app(static::class);
    }
}
