<?php

namespace Albedo\Duel\Models\Traits;

use Albedo\Duel\Models\DuelUserAnswer;

trait CalculatesDuelStats
{
    public function countCorrectAnswers(): int
    {
        return $this->duelUserAnswers
            ->filter(fn(DuelUserAnswer $a) => $a->isCorrect())
            ->count();
    }

    public function countIncorrectAnswers(): int
    {
        return $this->duelUserAnswers
            ->filter(fn(DuelUserAnswer $a) => !$a->isCorrect())
            ->count();
    }
}
