<?php

namespace Albedo\Duel\Listeners;

use Albedo\Duel\Enums\DuelProgressStatusEnum;
use Albedo\Duel\Events\DuelCloseEvent;
use Albedo\Duel\Events\DuelPossibleEndEvent;
use Albedo\Duel\Events\DuelUserFinishedAsFirstEvent;
use Albedo\Duel\Models\Duel;
use Albedo\Duel\Models\DuelUser;
use Albedo\Duel\Models\DuelUserAnswer;

class CheckIfDuelShouldBeClosedListener
{
    public function handle(DuelPossibleEndEvent $event): void
    {
        $finishedCount = $event->duel
            ->duelUsers
            ->filter(fn(DuelUser $duelUser) => $duelUser->progress_status === DuelProgressStatusEnum::FINISHED)
            ->count();

        $event->duel
            ->duelUsers
            ->each(function (DuelUser $duelUser) use ($finishedCount) {

                $duelUserAnswerCount = $duelUser->duelUserAnswers
                    ->reject(fn(DuelUserAnswer $duelUserAnswer) => !is_null($duelUserAnswer->answer_expiration_date))
                    ->count();

                if ($duelUserAnswerCount === 0 && $duelUser->progress_status !== DuelProgressStatusEnum::FINISHED) {

                    $duelUser->update([
                        'progress_status' => DuelProgressStatusEnum::FINISHED,
                        'time' => $duelUser->getSumTimeSeconds(),
                    ]);

                    if ($finishedCount === 0){
                        event(new DuelUserFinishedAsFirstEvent($duelUser));
                    }
                }
            });

        $numberOfNoResponses = $event->duel
            ->duelUserAnswers
            ->reject(fn(DuelUserAnswer $duelUserAnswer) => !is_null($duelUserAnswer->answer_expiration_date))
            ->count();

        if ($numberOfNoResponses === 0 and $event->duel->progress_status !== DuelProgressStatusEnum::FINISHED) {
            event(new DuelCloseEvent($event->duel));
        }
    }
}
