<?php

namespace Albedo\Duel\Models;

use Albedo\Duel\Enums\DuelProgressStatusEnum;
use Albedo\Duel\Enums\DuelResultStatusEnum;
use Albedo\Duel\Models\Traits\HasDuelProgressStatus;
use Albedo\Duel\Models\Traits\HasDuelResultStatus;
use Albedo\Duel\Models\Traits\InteractsWithDuelUserAnswer;
use Albedo\Gamification\Enums\ActivityGroupEnum;
use Albedo\Gamification\Models\Traits\PointableTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class DuelUserAnswer extends Model
{
    use InteractsWithDuelUserAnswer,
        HasFactory,
        PointableTrait,
        SoftDeletes;

    protected $fillable = [
        'duel_id',
        'duel_user_id',
        'duel_question_id',
        'duel_answer_id',
        'is_correct',
        'timeout',
        'answer_expiration_date',
        'answer_time',
        'number',
        'number_by_category',
    ];

    protected $casts = [
        'is_correct' => 'bool',
        'timeout' => 'bool',
        'answer_expiration_date' => 'datetime',
        'answer_time' => 'int',
        'number' => 'int',
        'number_by_category' => 'int',
    ];

    public function duel(): BelongsTo
    {
        return $this->belongsTo(Duel::class);
    }

    public function duelUser(): BelongsTo
    {
        return $this->belongsTo(DuelUser::class);
    }

    public function duelQuestion(): BelongsTo
    {
        return $this->belongsTo(DuelQuestion::class);
    }

    public function duelAnswer(): BelongsTo
    {
        return $this->belongsTo(DuelAnswer::class);
    }

    public static function getTotalQuestions(): int
    {
        return app(\Albedo\Duel\Settings\DuelSettings::class)->total_questions;
    }

    public static function getTotalQuestionsByCategory(): int
    {
        return app(\Albedo\Duel\Settings\DuelSettings::class)->total_questions_by_category;
    }

    /**
     * Factory
     */
    protected static function newFactory()
    {
        return \Albedo\Duel\Database\Factories\DuelUserAnswerFactory::new();
    }
}
