<?php

namespace Albedo\Duel;

use Albedo\Duel\Commands\CloseUserDuelsCommand;
use Albedo\Duel\Commands\DuelGenerateDuelTestCommand;
use Albedo\Duel\Commands\DuelRoundGeneratorCommand;
use Albedo\Duel\Commands\MakeUserDuelsCommand;
use Albedo\Duel\Commands\SendEmailToRemindOfDuelsCommand;
use Albedo\Duel\Events\DuelCloseEvent;
use Albedo\Duel\Events\DuelPossibleEndEvent;
use Albedo\Duel\Listeners\CheckIfDuelShouldBeClosedListener;
use Albedo\Duel\Listeners\CloseDuelListener;
use Albedo\Duel\Models\Duel;
use Albedo\Duel\Policies\DuelPolicy;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Gate;
use Spatie\LaravelPackageTools\Commands\InstallCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class DuelServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('duel')
            ->hasConfigFile()
            ->hasCommands([
                DuelGenerateDuelTestCommand::class,
                DuelRoundGeneratorCommand::class,
                MakeUserDuelsCommand::class,
                SendEmailToRemindOfDuelsCommand::class,
                CloseUserDuelsCommand::class,
            ])
            ->hasInstallCommand(function(InstallCommand $command) {
                $command
                    ->publishConfigFile()
                    ->publishAssets()
                    ->publishMigrations()
                    ->copyAndRegisterServiceProviderInApp();
            })
            ->hasRoute('duel')
            ->hasMigrations([
                '2022_08_25_164456_create_duel_rounds_table',
                '2022_08_25_164458_create_duels_table',
                '2022_08_25_165513_create_duel_users_table',
                '2022_09_07_102325_create_duel_question_categories_table',
                '2022_09_07_110934_create_duel_questions_table',
                '2022_09_07_111042_create_duel_answers_table',
                '2022_09_07_111043_create_duel_user_answers_table',
                '2025_11_19_121749_update_users_table'
            ])
            ->runsMigrations();
    }

    public function packageBooted()
    {
        $this->app->bind(
            \Albedo\Duel\Contracts\DuelUserDataProvider::class,
            \Albedo\Duel\DefaultDuelUserDataProvider::class
        );

        $this->app->bind(\Albedo\Duel\Services\CurrentDuelService::class);
        $this->app->bind(\Albedo\Duel\Services\DuelHistoryService::class);
        $this->app->bind(\Albedo\Duel\Services\DuelDetailsService::class);
        $this->app->bind(\Albedo\Duel\Services\NextDuelQuestionService::class);
        $this->app->bind(\Albedo\Duel\Services\AnswerDuelQuestionService::class);

        Event::listen(DuelPossibleEndEvent::class, CheckIfDuelShouldBeClosedListener::class);
        Event::listen(DuelCloseEvent::class, CloseDuelListener::class);

        Gate::policy(Duel::class, DuelPolicy::class);

    }
}
