<?php

namespace Albedo\Duel\Services;

use Albedo\Duel\Enums\DuelProgressStatusEnum;
use Albedo\Duel\Http\Resources\DuelResource;
use Albedo\Duel\Models\Duel;

class DuelHistoryService
{
    public function handle(int $userId)
    {
        $duels = Duel::whereHas('duelUsers', fn($q) => $q
            ->whereUserId($userId)
            ->whereProgressStatus(DuelProgressStatusEnum::FINISHED)
        )
            ->with('duelUsers.duelUserAnswers')
            ->orderByDesc('created_at')
            ->get();

        return $duels->map(function (Duel $duel) use ($userId) {
            $me = $duel->duelUsers->where('user_id', $userId)->first();
            $opponent = $duel->duelUsers->where('user_id', '!=', $userId)->first();
            return DuelResource::make($duel)->additional([
                'me' => $me,
                'opponent' => $opponent
            ]);
        });
    }
}
