<?php

namespace Albedo\Duel\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class DuelAnswer extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'duel_question_id',
        'answer',
        'is_valid',
    ];

    public function duelQuestion(): BelongsTo
    {
        return $this->belongsTo(DuelQuestion::class);
    }

    public function duelUserAnswer(): HasMany
    {
        return $this->hasMany(DuelUserAnswer::class);
    }

    protected static function newFactory()
    {
        return \Albedo\Duel\Database\Factories\DuelAnswerFactory::new();
    }
}
