<?php

namespace Albedo\Duel\Database\Factories;

use Albedo\Duel\Enums\DuelProgressStatusEnum;
use Albedo\Duel\Enums\DuelResultStatusEnum;
use Albedo\Duel\Models\Duel;
use Albedo\Duel\Models\DuelUser;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class DuelUserFactory extends Factory
{
    protected $model = DuelUser::class;

    public function definition(): array
    {
        return [
            'duel_id' => Duel::factory(),
            'user_id' => config('duel.user_model')::factory(),
            'progress_status' => DuelProgressStatusEnum::NOT_PARTICIPATED,
            'result_status' => DuelResultStatusEnum::UNKNOWN,
            'started_at' => null,
            'ended_at' => null,
            'points' => null,
            'time' => null,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
