<?php

use Albedo\Duel\Models\Duel;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('duel_users', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Duel::class);
            $table->foreignIdFor(config('duel.user_model'));
            $table->timestamp('started_at')->nullable();
            $table->timestamp('ended_at')->nullable();
            $table->string('progress_status')->nullable();
            $table->string('result_status')->nullable();
            $table->integer('points')->nullable();
            $table->string('time')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('duel_users');
    }
};
