<?php

namespace Albedo\Duel\Commands;

use Albedo\Duel\Models\Duel;
use Albedo\Duel\Models\DuelAnswer;
use Albedo\Duel\Models\DuelQuestion;
use Albedo\Duel\Models\DuelQuestionCategory;
use Albedo\Duel\Models\DuelRound;
use Albedo\Duel\Models\DuelUser;
use Albedo\Duel\Models\DuelUserAnswer;
use Illuminate\Console\Command;

class DuelGenerateDuelTestCommand extends Command
{
    protected $signature = 'duel:generate-duel-test {user1=1} {user2=2}';

    protected $description = 'Command description';

    public function handle(): void
    {

        $duelRound = DuelRound::getCurrent() ?? DuelRound::factory()->create();

        $duel = Duel::factory()->create(['duel_round_id' => $duelRound->id]);

        $user1 = $user1 ?? config('duel.user_model')::find($this->argument('user1'));
        $user2 = $user2 ?? config('duel.user_model')::find($this->argument('user2'));

        $duelUser1 = DuelUser::factory()->create(['duel_id' => $duel->getKey(), 'user_id' => $user1->getKey()]);
        $duelUser2 = DuelUser::factory()->create(['duel_id' => $duel->getKey(), 'user_id' => $user2->getKey()]);

        $categories = DuelQuestionCategory::factory()->count(3)->create();

        $numberQuestion = 1;
        $categories->each(function (DuelQuestionCategory $duelQuestionCategory, $numberDuelQuestionCategory)
        use ($duel, $duelUser1, $duelUser2, &$numberQuestion) {

            $duelQuestions = DuelQuestion::factory()
                ->has(DuelAnswer::factory()->count(3)->incorrect())
                ->has(DuelAnswer::factory()->correct())
                ->count(3)
                ->create([
                    'duel_round_id' => $duel->duel_round_id,
                    'duel_question_category_id' => $duelQuestionCategory->id
                ]);

            $duelQuestions->each(function (DuelQuestion $duelQuestion) use ($duel, $duelUser1, $duelUser2, $numberDuelQuestionCategory, &$numberQuestion) {
                DuelUserAnswer::factory()->create([
                    'duel_id' => $duel->getKey(),
                    'duel_user_id' => $duelUser1->id,
                    'duel_question_id' => $duelQuestion->id,
                    'number_by_category' => $numberDuelQuestionCategory,
                    'number' => $numberQuestion
                ]);

                DuelUserAnswer::factory()->create([
                    'duel_id' => $duel->getKey(),
                    'duel_user_id' => $duelUser2->id,
                    'duel_question_id' => $duelQuestion->id,
                    'number_by_category' => $numberDuelQuestionCategory,
                    'number' => $numberQuestion
                ]);

                $numberQuestion++;

            });
        });
    }
}
