<?php

use Albedo\Duel\Http\Controllers\DuelHistoryAction;
use Albedo\Duel\Http\Controllers\DuelController;
use Albedo\Duel\Http\Controllers\DuelShowAction;
use Albedo\Duel\Http\Controllers\DuelQuestionAction;
use Albedo\Duel\Models\Duel;

Route::group([
    'as' => config('duel.route.as'),
    'prefix' => config('duel.route.prefix', 'api'),
    'middleware' => config('duel.route.middleware'),
], function () {

    Route::get('/question/{duel}', DuelQuestionAction::class)
        ->middleware('can:question,duel')
        ->name('question');

    Route::post('/answer/{duel}', [DuelController::class, 'storeAnswer'])
        ->middleware('can:answer,duel')
        ->name('answer');

    Route::get('/show/{duel}', DuelShowAction::class)
        ->middleware('can:show,duel')
        ->name('show');

    Route::get('/summary/{duel}', [DuelController::class, 'summary'])
        ->middleware('can:summary,duel')
        ->name('summary');

    Route::get('/history', DuelHistoryAction::class)
        ->can('history', Duel::class)
        ->name('history');

});
