<?php

namespace Albedo\Duel\Database\Factories;

use Albedo\Duel\Models\DuelQuestion;
use Albedo\Duel\Models\DuelQuestionCategory;
use Albedo\Duel\Models\DuelRound;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\DuelQuestion>
 */
class DuelQuestionFactory extends Factory
{
    protected $model = DuelQuestion::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'duel_round_id' => DuelRound::first(),
            'duel_question_category_id' => DuelQuestionCategory::first(),
            'question' => Str::repeat('x', fake()->numberBetween(3,20)),
            'is_active' => true,
        ];
    }
}
