<?php

namespace Albedo\Duel\Database\Factories;

use Albedo\Duel\Models\DuelAnswer;
use Albedo\Duel\Models\DuelQuestion;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\DuelAnswer>
 */
class DuelAnswerFactory extends Factory
{
    protected $model = DuelAnswer::class;
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'duel_question_id' => DuelQuestion::factory(),
            'answer' => Str::repeat('x', fake()->numberBetween(5, 10)),
            'is_valid' => true,
        ];
    }

    public function correct()
    {
        return $this->state(fn (array $attributes) => [
            'is_valid' => true,
        ]);
    }

    public function incorrect()
    {
        return $this->state(fn (array $attributes) => [
            'is_valid' => false,
        ]);
    }
}
