<?php

namespace Albedo\Duel\Listeners;

use Albedo\Duel\Events\DuelCloseEvent;
use Albedo\Duel\Events\DuelResolvedEvent;
use Albedo\Duel\Events\UserWonDuelEvent;
use Albedo\Duel\Models\Duel;
use Albedo\Duel\Models\DuelUser;
use Albedo\Duel\Models\DuelUserAnswer;
use Albedo\Duel\Services\DuelService;

class CloseDuelListener
{

    public function __construct(protected DuelService $duelService)
    {

    }

    public function handle(DuelCloseEvent $event): void
    {
        $this->duelService->resolveDuel($event->duel);
    }
}
