<?php

namespace Albedo\Duel\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DuelAnswerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'question_id' => [
                'required',
                'integer',
                'exists:duel_questions,id',
            ],
            'answer_id' => [
                'required',
                'integer',
                'exists:duel_answers,id',
            ],
        ];
    }
}
