<?php

namespace Albedo\Duel\Http\Controllers;

use Albedo\Duel\Services\DuelDetailsService;
use Exception;
use Albedo\Duel\Models\Duel;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

class DuelShowAction extends Controller
{
    public function __construct(
        protected DuelDetailsService $getDuelDetails
    ){}

    public function __invoke(Duel $duel)
    {
        $userId = (int) auth()->id();

        try {
            $duelResource = $this->getDuelDetails->handle($duel, $userId);
        } catch (Exception $e) {
            report($e);
            return Response::generalError();
        }

        return Response::success(
            data: $duelResource,
            message: "Duel information retrieved successfully");
    }
}
