<?php

namespace Albedo\Duel\Http\Controllers;

use Albedo\Duel\Services\CurrentDuelService;
use Albedo\Duel\Exceptions\NoActiveDuelRoundException;
use Albedo\Duel\Exceptions\NoActiveDuelException;
use Exception;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

class DuelCurrentAction extends Controller
{
    public function __construct(
        protected CurrentDuelService $getCurrentDuel
    ) {}

    public function __invoke()
    {
        $userId = (int) auth()->id();
        try {
            $duelResource = $this->getCurrentDuel->handle($userId);
        } catch (NoActiveDuelRoundException $ex) {
            return Response::error(message: $ex->getMessage(), status: 404);
        } catch (NoActiveDuelException $ex) {
            return Response::error(message: $ex->getMessage(), status: 404);
        } catch (Exception $e) {
            report($e);
            return Response::generalError();
        }
        return Response::success(data: $duelResource);
    }
}
