<?php

namespace Albedo\Duel\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class DuelQuestion extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'duel_round_id',
        'duel_question_category_id',
        'question',
        'is_active'
    ];

    public function duel(): BelongsTo
    {
        return $this->belongsTo(Duel::class);
    }

    public function duelQuestionCategory(): BelongsTo
    {
        return $this->belongsTo(DuelQuestionCategory::class);
    }

    public function duelAnswers(): HasMany
    {
        return $this->hasMany(DuelAnswer::class);
    }

    public function duelRound(): BelongsTo
    {
        return $this->belongsTo(DuelRound::class);
    }

    public function getCorrectAnswer(): DuelAnswer
    {
        return $this->duelAnswers->where('is_valid', true)->first();
    }

    protected static function newFactory()
    {
        return \Albedo\Duel\Database\Factories\DuelQuestionFactory::new();
    }
}
