<?php

namespace Albedo\Duel\Commands;

use Albedo\Duel\Services\DuelGeneratorService;
use Illuminate\Console\Command;
use Throwable;

class MakeUserDuelsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'duel:generate';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    public function __construct(protected DuelGeneratorService $service)
    {
        parent::__construct();
    }

    public function handle(): int
    {
        try {
            $this->service->generate();
            $this->info('Duels generated.');
        } catch (Throwable $e) {
            $this->error($e->getMessage());
            return self::FAILURE;
        }

        return self::SUCCESS;
    }
}
