<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Http\Resources\UserProfileResource;
use Exception;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Support\Facades\Response;

class ProfileAction extends Controller
{
    public function __construct(protected Authenticatable $user)
    {

    }
    public function __invoke()
    {
        try {
            return Response::success(data: UserProfileResource::make($this->user));
        } catch (Exception $ex) {
            return Response::error(message: 'Failed to get profile.', status: 500);
        }
    }
}
