<?php

namespace Albedo\Auth\Services;

use Albedo\Auth\Contracts\LogsInParticipantsInterface;
use Albedo\Auth\Exceptions\IncorrectLoginException;
use Albedo\Auth\Exceptions\UnverifiedAccountException;
use Albedo\Auth\Providers\DefaultAuthUserProvider;
use Illuminate\Auth\Events\Login;
use Illuminate\Support\Facades\Hash;

class LoginService implements LogsInParticipantsInterface
{
    public function __construct(protected DefaultAuthUserProvider $authUserProvider)
    {

    }

    /**
     * @throws UnverifiedAccountException
     * @throws IncorrectLoginException
     */
    public function login(array $data, string $tokenName = null): string
    {
        $login = $data['login'];
        $password = $data['password'];

        $user = $this->authUserProvider->getUserModel()::query()
            ->where('email', $login)
            ->first();

        if (is_null($user) || !Hash::check($password, $user->password)) {
            throw new IncorrectLoginException();
        }

        if (!$user->hasVerifiedEmail()) {
            throw new UnverifiedAccountException();
        }

        $token = $user->createToken($tokenName)->plainTextToken;

        event(new Login($tokenName, $user, false));

        return $token;
    }
}
