<?php

namespace Albedo\Auth\Models\Traits;

trait HasUserName
{
    public function getFirstName(): string
    {
        return ucfirst($this->first_name ?? '');
    }

    public function getLastName(): string
    {
        return ucfirst($this->last_name ?? '');
    }

    public function getShortFirstName(): string
    {
        return $this->first_name
            ? ucfirst(substr($this->first_name, 0, 1)) . '.'
            : '';
    }

    public function getShortLastName(): string
    {
        return $this->last_name
            ? ucfirst(substr($this->last_name, 0, 1)) . '.'
            : '';
    }

    public function getFullName(): string
    {
        return trim($this->getFirstName() . ' ' . $this->getLastName());
    }

    public function getShortName(): string
    {
        return trim($this->getFirstName() . ' ' . $this->getShortLastName());
    }
}
