<?php

namespace Albedo\Auth\Services;

use Albedo\Auth\Contracts\RegistersParticipantsInterface;
use Albedo\Auth\Providers\DefaultAuthUserProvider;
use Albedo\Gamification\Contracts\HasAvatar;
use Albedo\Gamification\Contracts\MustAcceptUserAgreements;
use Albedo\Gamification\Services\AgreementService;
use Albedo\Gamification\Services\AvatarService;
use Illuminate\Auth\Events\Registered;

class RegisterService implements RegistersParticipantsInterface
{
    public function __construct(
        protected DefaultAuthUserProvider $authUserProvider,
        protected AgreementService        $agreementService,
        protected AvatarService           $avatarService,
    )
    {

    }

    public function register(array $data)
    {


        $user = $this->authUserProvider->getUserModel()::create($data);

        if ($user instanceof MustAcceptUserAgreements) {
            $this->agreementService->acceptAgreements($user, $data);
        }

        if ($user instanceof HasAvatar) {
            $this->avatarService->assignAvatarFromRequest($user, $data);
        }

        event(new Registered($user));

        return $user;
    }
}
