<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Contracts\RegistersParticipantsInterface;
use Albedo\Auth\Http\Requests\RegisterRequest;
use Exception;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

/**
 * Rejestracja nowego użytkownika.
 *
 * @group Rejestracja
 * Endpoint rejestrujący nowego użytkownika w systemie.
 *
 * @bodyParam first_name string required Imię. Example: Jan
 * @bodyParam last_name string required Nazwisko. Example: Kowalski
 * @bodyParam email string required Adres e-mail. Example: j.kowalski@domena.pl
 * @bodyParam phone_number string required Numer telefonu użytkownika. Example: 123456789
 * @bodyParam password string required Hasło. Example: SilneHasło123!
 * @bodyParam password_confirmation string required Potwierdzenie hasła. Example: SilneHasło123!
 * @bodyParam avatar_id integer required Avatar użytkownika (ID). Example: 1
 *
 * @response 200 {"message": "Register successful."}
 */
class RegisterAction extends Controller
{
    public function __construct(
        protected RegistersParticipantsInterface $authService
    )
    {
    }

    /**
     * Rejestracja nowego użytkownika.
     *
     * @group Rejestracja
     * Endpoint rejestrujący nowego użytkownika w systemie.
     *
     * @bodyParam first_name string required Imię. Example: Jan
     * @bodyParam last_name string required Nazwisko. Example: Kowalski
     * @bodyParam email string required Adres e-mail. Example: j.kowalski@domena.pl
     * @bodyParam phone_number string required Numer telefonu użytkownika. Example: 123456789
     * @bodyParam password string required Hasło. Example: SilneHasło123!
     * @bodyParam password_confirmation string required Potwierdzenie hasła. Example: SilneHasło123!
     * @bodyParam avatar_id integer required Avatar użytkownika (ID). Example: 1
     * @bodyParam {zgoda} boolean required Akceptacja zgody (np. regulations). Example: true
     *
     * @response 200 {"message": "Register successful."}
     */
    public function __invoke(RegisterRequest $request)
    {
        try {
            $this->authService->register($request->validated());
        } catch (Exception $e) {
            report($e);
            return Response::generalError();
        }

        return Response::success(
            message: 'Register successful.',
        );
    }
}
