<?php

namespace Albedo\Auth\Http\Requests;

use Albedo\Gamification\Services\AgreementService;
use Albedo\Gamification\Services\AvatarService;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class RegisterRequest extends FormRequest
{
    public function __construct(
        protected AgreementService $agreementService,
        protected AvatarService $avatarService
    )
    {
    }

    public function rules(): array
    {
        return [

            'first_name' => [
                'required',
                'string',
                'min:3',
                'max:30',
            ],

            'last_name' => [
                'required',
                'string',
                'min:3',
                'max:30',
            ],

            'email' => [
                'required',
                'string',
                'confirmed',
                'unique:users,email',
                'email:rfc,dns',
                'max:255',
            ],

            'phone_number' => ['required'],

            'password' => [
                'required',
                'confirmed',
                'max:255',
                Password::defaults()
            ],

            'password_confirmation' => ['required', 'same:password'],

            ...$this->agreementService->getAgreementRules(),

            ...$this->avatarService->getAvatarRules(),
        ];
    }

    public function authorize(): bool
    {
        return true;
    }
}
