<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Http\Resources\UserProfileResource;
use Exception;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Support\Facades\Response;

/**
 * Pobiera profil bieżącego użytkownika.
 *
 * @group Zarządzanie kontem
 * Endpoint do pobrania danych aktualnie zalogowanego użytkownika.
 *
 * @authenticated
 * @response 200 {"data": {"id": 1, "email": "jankowalski@domena.pl"}} !!ELEMENT DO ROZBUDOWY!!
 * @response 500 {"message": "Failed to get profile."}
 */
class ProfileAction extends Controller
{
    public function __construct(protected Authenticatable $user)
    {

    }
    /**
     * Zwraca dane profilowe aktualnie zalogowanego użytkownika.
     *
     * @response 200 {"data": {"id": 1, "email": "jankowalski@domena.pl"}}
     * @response 500 {"message": "Failed to get profile."}
     */
    public function __invoke()
    {
        try {
            return Response::success(data: UserProfileResource::make($this->user));
        } catch (Exception $ex) {
            return Response::error(message: 'Failed to get profile.', status: 500);
        }
    }
}
