<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Enums\ActionType;
use Albedo\Auth\Http\Requests\VerificationRequest;
use Albedo\Auth\Models\ActionCode;
use Albedo\Auth\Services\ActionCodeService;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Auth\Events\Verified;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;

class VerificationAction extends Controller
{
    public function __construct(protected ActionCodeService $actionCodeService)
    {

    }

    public function __invoke(VerificationRequest $request)
    {
        $user = app(config('albedo-auth.user_model'))::query()
            ->findOrFail($request->query('id'));

        $code = $request->input('code');

        if ($user->hasVerifiedEmail()) {
            return Response::error(
                message: 'The account has already been verified.'
            );
        }

        if (!$this->actionCodeService->validateAndConsume($user, ActionType::VERIFICATION_ACCOUNT, $code)) {
            return Response::error(
                message: 'Invalid or expired code.'
            );
        }

        $user->markEmailAsVerified();

        event(new Verified($user));

        return Response::success(
            message: 'Your account has been verified.',
        );
    }
}
