<?php

namespace Albedo\Auth\Models;

use Albedo\Auth\Enums\ActionType;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Random\RandomException;

class ActionCode extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'type',
        'code',
        'expires_at',
        'consumed_at',
    ];

    protected $casts = [
        'type' => ActionType::class,
        'expires_at' => 'datetime',
        'consumed_at' => 'datetime',
    ];

    /**
     * @throws RandomException
     */
    public static function generateActionCodeFor($user, ActionType $type)
    {
        return self::query()->create([
            'user_id' => $user->getAuthIdentifier(),
            'type' => $type,
            'code' => str_pad((string) random_int(0, 999999), 6, '0', STR_PAD_LEFT),
            'expires_at' => now()->addMinutes(10),
        ]);
    }

    public function isExpired(): bool
    {
        return $this->expires_at?->isPast() ?? true;
    }

    public function isConsumed(): bool
    {
        return $this->consumed_at !== null;
    }

    public function markConsumed(): void
    {
        $this->consumed_at = now();
        $this->save();
    }
}


