<?php

namespace Albedo\Auth\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class VerificationCodeResetPasswordRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'email' => 'required', 'string', 'email', 'max:255',
            'code' => 'required',
            'g-recaptcha-response' => config('albedo-auth.recaptcha_enabled') ?
                (($this->header('X-Client-Type', 'web') == 'mobile') ?
                    'nullable' : 'required|captcha')
                : 'nullable',
        ];
    }

    public function authorize(): bool
    {
        return true;
    }

    public function messages()
    {
        return config('albedo-auth.custom_validation_messages.verification_code_reset_password') ?? parent::messages();
    }
}
