<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Http\Requests\UserChangePasswordRequest;
use Exception;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

/**
 * Akcja zmiany hasła użytkownika.
 *
 * @group Zarządzanie kontem
 *
 * Endpoint umożliwiający autoryzowanemu użytkownikowi zmianę własnego hasła.
 *
 * @authenticated
 * @response 200 {"message": "Password changed successfully."}
 * @response 422 {"message": "Failed to change password."}
 */
class ChangePasswordAction extends Controller
{

    /**
     * Zmienia hasło zalogowanego użytkownika.
     *
     * @bodyParam old_password string required Aktualne hasło użytkownika. Example: SilneHasło123!
     * @bodyParam password string required Nowe hasło użytkownika. Example: SilneHasło123!
     * @bodyParam password_confirmation string required Powtórzenie nowego hasła. Example: SilneHasło123!
     *
     * @response 200 {"message": "Password changed successfully."}
     * @response 422 {"message": "Failed to change password."}
     */
    public function __invoke(UserChangePasswordRequest $request)
    {
        try {
            auth()->user()->update(['password' => bcrypt($request->password)]);
        } catch (Exception $e) {
            report($e);
            return Response::error(message: 'Failed to change password.');
        }

        return Response::success(
            message: 'Password changed successfully.'
        );
    }
}
