<?php

namespace Albedo\Auth\Listeners;

use Albedo\Auth\Enums\ActionType;
use Albedo\Auth\Mail\RegistrationCodeMail;
use Albedo\Auth\Services\ActionCodeService;
use Albedo\Auth\Settings\CodeExpirationTimeSettings;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Mail;

class SendVerificationCodeOnRegistrationListener
{
    public function __construct(
        protected ActionCodeService $actionCodeService,
        protected CodeExpirationTimeSettings $codeExpirationTimeSettings
    )
    {
    }

    public function handle(Registered $event): void
    {
        $actionCode = $this->actionCodeService->generate(
            $event->user,
            ActionType::VERIFICATION_ACCOUNT,
            $this->codeExpirationTimeSettings->account_verification_code
        );

        Mail::to($event->user->email)
            ->queue(new RegistrationCodeMail($actionCode->code));
    }
}
