<?php

namespace Albedo\Auth\Contracts;

use Albedo\Auth\Exceptions\ExpiredPasswordResetTokenException;
use Albedo\Auth\Exceptions\InvalidPasswordResetTokenException;
use Illuminate\Database\Eloquent\ModelNotFoundException;

interface RecoversParticipantPasswordsInterface
{
    /**
     * @param array $data
     * @return void
     * @throws ModelNotFoundException
     */
    public function remind(array $data): void;

    /**
     * @param array $data
     * @return void
     * @throws ModelNotFoundException
     * @throws ExpiredPasswordResetTokenException
     * @throws InvalidPasswordResetTokenException
     */
    public function reset(array $data): void;

    /**
     * @param array $data
     * @return string
     * @throws InvalidPasswordResetTokenException
     */
    public function verify(array $data): string;
}
