<?php

namespace Albedo\Auth\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Mockery\Exception;

class DeleteUserNotVerifiedCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'auth:delete-not-verified';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $user = config('albedo-auth.user_model');
        $lifetime = config('albedo-auth.user_unverified_lifetime');

        $user::query()
            ->unverified()
            ->where('created_at', '<=',  now()->sub($lifetime))
            ->chunkById(100, function ($users) {
                $users->each(function ($user) {
                    try {
                        $user->delete();
                        Log::info('Participant removed. Participant not verified.', $user->toArray());
                    } catch (Exception $ex) {
                        report($ex);
                    }
                });
            });

        $this->info('Deleted users not verified for more than ' . $lifetime . ' days.');

        return self::SUCCESS;
    }
}
