<?php

namespace Albedo\Auth\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class UserResetPasswordRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'token' => 'required',
            'email' => 'required|email',
            'password' => ['required', 'same:password_confirmation', 'max:255', Password::defaults()],
            'password_confirmation' => 'required|same:password'
        ];
    }

    public function authorize(): bool
    {
        return true;
    }
}
