<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Http\Requests\UserResetPasswordRequest;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class ResetPasswordAction extends Controller
{
    public function __invoke(UserResetPasswordRequest $request): JsonResponse
    {
        try {
            Password::reset(
                $request->validated(),
                static function ($user, $password) {

                    if (!$user->hasVerifiedEmail()) {
                        throw new AuthorizationException('Account has not been verified.');
                    }

                    $user->forceFill([
                        'password' => Hash::make($password)
                    ])
                        ->setRememberToken(Str::random(60));

                    $user->save();

                    $user->tokens()->delete();

                    event(new PasswordReset($user));
                }
            );

            return Response::success(
                message: __('Password has been changed.'),
            );
        } catch (AuthorizationException $ex) {
            return Response::error(
                message: $ex->getMessage(),
                status: 409,
            );
        } catch (Exception $e) {
            Log::error($e);
            return response::error(message: __('Error has occurred.'));
        }
    }
}
