<?php

use Albedo\Auth\Http\Controllers\LoginAction;
use Albedo\Auth\Http\Controllers\LogoutAction;
use Albedo\Auth\Http\Controllers\RemindPasswordAction;
use Albedo\Auth\Http\Controllers\ResetPasswordAction;
use Albedo\Auth\Http\Controllers\VerificationAction;
use Albedo\Auth\Http\Controllers\ChangePasswordAction;
use Albedo\Auth\Http\Controllers\ProfileAction;

Route::group([
    'as' => config('albedo-auth.route.as'),
    'prefix' => config('albedo-auth.route.prefix', 'api'),
//    'middleware' =>  config('albedo_auth.route.middleware'),
], function () {

    // Public routes (e.g., login, password reset)
    Route::post('login', LoginAction::class)->name('login');
    Route::post('forgot-password', RemindPasswordAction::class)->name('forgot-password');
    Route::post('reset-password/{token}', ResetPasswordAction::class)->name('password-reset');
    Route::post('account-verification', VerificationAction::class)->name('account-verification');

    // Routes requiring Sanctum authentication
    Route::group([
        'middleware' => config('albedo-auth.authentication.route.middleware'),
    ], function () {
        Route::post('logout', LogoutAction::class)->name('logout');
        Route::post('change-password', ChangePasswordAction::class)->name('change-password');
        Route::get('profile', ProfileAction::class)->name('profile');
        // Other authenticated routes go here
    });
});
